
; make-distribution - this is part of workspace file for distributor

(setf distributor "*sssst-4st*")
(setf *sssst-4st* t)
(setf *phase0-id* "1.")
(setf *net-install* t)



  (define-vista-paths)
;

(setf *distribution-date* (time-stamp))
(setf *distribution-id* (user-id))
(setf *distributor-id* (strcat *distribution-id* "*sssst-4st*"))

(defun make-distribution ()
  (setf *make-distribution* t)
  (setf *build-number* (1+ *build-number*))
  (vista-release-numbers)
 ; (setf *vista-subminor-release* 
 ;       (if *vista-subminor-release* (1+ *vista-subminor-release*) 0))
  (setf *next-vista-subminor-release-string* (format nil "~a" *vista-subminor-release*))
  (when (= (length *next-vista-subminor-release-string*) 1) 
        (setf *next-vista-subminor-release-string* 
              (strcat "0" *next-vista-subminor-release-string* )))
  (let* ((ta (send text-item-proto :new 
                   (strcat "NOW:: ViSta-" *release-number* " " *release-date*)))
         (tb (send text-item-proto :new "SPECIFY INSTALLATION VERSION"))
         (tc (send text-item-proto :new "SPECIFY INSTALLATION TYPE"))
         (t1 (send text-item-proto :new "New Release Date" ))
         (t2 (send text-item-proto :new "New Release Number"))
         (t6 (send text-item-proto :new "New Build Number"))
         (t3 (send text-item-proto :new "Release Language"))
         (t5 (send text-item-proto :new 
                   (format nil "NEXT: ViSta-~a.~a.~a.~a ~a"
                           *vista-major-release-string*  
                           *vista-minor-release-string*  
                           *next-vista-subminor-release-string* 
                           *build-number*
                           *release-date*)))
         (e1 (send edit-text-item-proto :new (first (date-time)) :text-length 18))
         (e2 (send edit-text-item-proto :new 
                   (format nil "~a.~a.~a" *vista-major-release*
                           *vista-minor-release-string*
                           *next-vista-subminor-release-string* ) 
                   :text-length 18))
         (e3 (send edit-text-item-proto :new *release-language* :text-length 18))
         (e4 (send toggle-item-proto :new "ReInstall for Developers?"
                   :initial *install-developer*))
         (e5 (send toggle-item-proto :new "Install for Distribution?"
                   :initial *install-developer*))
         (e6 (send edit-text-item-proto :new (format nil "~a" *build-number*) :text-length 18))
         (ok (send modal-button-proto :new "OK"
                   :action #'(lambda ()
                               (list (send e1 :text) (send e2 :text) 
                                     (send e3 :text) (send e4 :value)
                                     (send e5 :value)(send e6 :text)))
                   :initial *install-developer*))
         (cancel (send modal-button-proto :new "Cancel"))
         (dialog (send modal-dialog-proto :new
                       (list (list (list TC e4 e5
                                         (list ok cancel))
                                   (list TB 
                                         (list e1 t1) 
                                         (list e2 t2)
                                         (list e6 t6)
                                         (list e3 t3)
                                         ))
                             (list TA t5))
                       :title "Distribution Maker"))
         (result (send dialog :modal-dialog)))
    (when result
          ;(please-wait "Preparing to Make Distribution Module." :pause 40)
          (msw-write-profile-string "ViSta" "XLispOnly" "No" *ini-file*)
          (when (first  result) (setf *release-date* (first  result)))
          (when (second result) 
                (setf *release-number* (strcat (second result) "." (sixth result))))
          (when (third  result) (setf *release-language* (third result)))
          (setf *install-developer* (fourth result))
          (setf *make-distribution* (fifth result))
          (setf *compiled-file-listing?* nil)
          (setf *show-make-steps?* t)
          (setf *run-number* -10)
          (setf *fast-start* t)
          (setf *show-web-docs* t)
          (send *vista* :show-welcome t)
          (send *vista* :show-first-help t)
          (setf *debug-mode* nil)
          (setf *verbose* nil)
          (setf *visible-startup* nil)
          (setf *pro-version* nil)
          (send *vista* :save-prefs t)                  
          (compile-changed-vista-sources)
          (setf *vista-start-case* 2)
          (setf *rebuild-after-compile-needed* nil)
          (set-working-directory *default-path*)
          (rename-ini)
          (rename-wks)
          (double-dribble)
          (save-all-prefs t)
          (system (strcat "vista.exe -f maketime" separator "maker.lsp"))
          (exit))
    ))




(defun add-distribution-item ()
  (let* ((items (send *devel-menu* :items))
         )
    (when items 
          (apply #'send *devel-menu* :delete-items items)
          (apply #'send *devel-menu* :append-items 
                 (combine 
                  (send menu-item-proto :new "Make Distribution"
                        :action #'make-distribution)
                  items)))))


;replaces null add-distribution-item function that is in defun1


;(progn
 ;(when *please-wait* (send *please-wait* :remove))
 ;(setf *please-wait* nil)
 ;(please-wait "Make ViSta: Distributor Privileges Granted" :title "Make ViSta")
 ;(please-wait "Make ViSta: Distributor Privileges Granted" :title "Make ViSta" 
 ;             :pause 30 :show-time 1)
 ;(setf *please-wait* nil)
 ;)


(defun spinit ()
  (let* ((i 0)
         (sign 1)
         (lr+ 2)
         (tb+ 1)
         (w 240)
         (h 120)
         (lr 2) (tb 1)
         (max-w (first screen-size)) 
         (max-h (+ 44 (second screen-size)))
         (dif-h (- max-h h))
         (dif-w (- max-w w))
         (c 2)
         (start-time (/ (get-internal-real-time)
                       internal-time-units-per-second))
         (margin (list (floor (* 1/2 dif-w)) (floor (* 1/2 dif-h)) 
                       (floor (* 1/2 dif-w)) (floor (* 1/2 dif-h))))
         )
    (send *logo* :top-most nil)
    (display-logo :number *run-number* :msg-number 102 :margin margin
                  :location '(0 -10) :size (list (+ 50 max-w) (+ 50 max-h)))
    (defmeth *logo* :do-click (x y m1 m2)
      (send self :idle-on nil)
      (send self :remove))
    (defmeth *logo* :do-key (c m1 m2)
      (send self :do-click))
    (defmeth *logo* :do-idle ()
      (setf i (1+ i))
      (let* ((current-time (/ (get-internal-real-time)
                       internal-time-units-per-second)))
        (when (> (- current-time start-time) 8)
              (setf start-time current-time)
              (send *logo* :next-message :repeat t))
        (send self :start-buffering)
        (cond 
          ((= i 100);720
           (send self :transformation nil)
           (send self :new-shape)
           (setf i 0))
          (t
           (when (> (uniform-rand 1) .5)(send self :rotate-2 0 1 (/ pi 360 c)))
           (when (> (uniform-rand 1) .5)(send self :rotate-2 0 2 (/ pi 360 c)))
           (when (> (uniform-rand 1) .5)(send self :rotate-2 0 3 (/ pi 360 c)))
           (when (> (uniform-rand 1) .5)(send self :rotate-2 1 2 (/ pi  45 c)))
           (when (> (uniform-rand 1) .5)(send self :rotate-2 1 3 (/ pi  45 c)))
           (when (> (uniform-rand 1) .5)(send self :rotate-2 2 3 (/ pi  45 c)))))
        (send self :buffer-to-screen)
        ))
  (send *logo* :idle-on t)
  ))
